/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldsObject;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWQuery;
import filenet.vw.api.VWReturnStackElement;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.server.IPECommands;
import filenet.vw.server.VWField;
import filenet.vw.server.VWWorkElementFields;
import filenet.vw.server.VWWorkObjectID;
import java.io.Serializable;

abstract class VWWorkElement
extends VWFieldsObject
implements Serializable {
    private static final long serialVersionUID = 7556L;
    protected VWQuery sourceQuery;
    protected VWWorkObjectID workObjectId;
    protected boolean bind;
    protected String bindUser;
    protected String exceptionInstructionSheet;
    protected String exceptionDescription;
    protected String mapName;
    protected boolean isExceptionMap = false;
    protected IPECommands theCmdSession = null;
    protected Object[] availableResponses = null;
    protected int selectedResponse = -1;

    protected VWWorkElement(VWField[] fieldValues, VWWorkObjectID work_object_Id, VWQuery source) {
        this.workObjectId = work_object_Id;
        this.setFields(fieldValues);
        this.sourceQuery = source;
        if (this.sourceQuery != null && this.sourceQuery.querySource != null) {
            this.theCmdSession = this.sourceQuery.querySource.cmdSession;
        }
    }

    protected static VWWorkObjectID[] getWorkObjectIds(VWWorkElement[] elements) {
        VWWorkObjectID[] ids = new VWWorkObjectID[elements.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = elements[i].workObjectId;
        }
        return ids;
    }

    protected void fetchFields(int resultType, boolean lock, boolean overrideLock) throws VWException {
        Object[] results = null;
        boolean trynormal = true;
        if (trynormal) {
            results = this.getSession().getWorkElementFields(this.sourceQuery.querySource.viewId, this.sourceQuery.queryType, new VWWorkObjectID[]{this.workObjectId}, resultType, lock, overrideLock, this.sourceQuery.userBoundQueueQuery, this.sourceQuery.queryFlags, 1);
        }
        if (results != null) {
            if (results[0] == null) {
                this.setFields(null);
                this.workObjectId = null;
                return;
            }
            if (results.length != 1) {
                throw new VWException("vw.api.WEFetchFieldsWrongResultSize", "The field data fetched from the server was the wrong size.");
            }
            if (results[0] instanceof VWException) {
                throw (VWException)results[0];
            }
            if (results[0] instanceof VWWorkElementFields) {
                this.setFields(((VWWorkElementFields)results[0]).fields);
                this.workObjectId = ((VWWorkElementFields)results[0]).workObjectId;
            }
        }
    }

    protected static VWException[] lockMany(VWWorkElement[] elements, boolean overrideLock, int resultType) throws VWException {
        int viewId = 0;
        if (elements == null || elements.length < 1) {
            throw new VWException("vw.api.WELockManyNoElements", "WorkObject or Element is not defined. No object to lock.");
        }
        if (elements[0] == null) {
            throw new VWException("vw.api.WELockManyNoArrayElement", "WorkObject or Element is null. No object to lock at index {0}. ", 0);
        }
        IPECommands cmdSession = elements[0].getSession();
        String sourceName = elements[0].sourceQuery.querySource.name;
        viewId = elements[0].sourceQuery.querySource.viewId;
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] != null) {
                if (sourceName.equals(elements[i].sourceQuery.querySource.name)) continue;
                throw new VWException("vw.api.WELockManyElementsMismatchQuery", "WorkObject or Element must be from the same query.  Element {0} is not.", i);
            }
            throw new VWException("vw.api.WELockManyNoArrayElement", "WorkObject or Element is null. No object to lock at index {0}. ", i);
        }
        boolean trynormal = true;
        Object[] objres = null;
        if (trynormal) {
            objres = cmdSession.getWorkElementFields(viewId, elements[0].sourceQuery.queryType, VWWorkElement.getWorkObjectIds(elements), resultType, true, overrideLock, elements[0].sourceQuery.userBoundQueueQuery, elements[0].sourceQuery.queryFlags, 0);
        }
        VWException[] results = null;
        int resLen = objres == null ? 0 : objres.length;
        results = new VWException[resLen];
        for (int i = 0; i < resLen; ++i) {
            if (objres[i] instanceof VWWorkElementFields) {
                elements[i].setFields(((VWWorkElementFields)objres[i]).fields);
                elements[i].workObjectId = ((VWWorkElementFields)objres[i]).workObjectId;
                results[i] = null;
                continue;
            }
            results[i] = objres[i] instanceof VWException ? (VWException)objres[i] : (objres[i] instanceof Exception ? new VWException("vw.api.WElockManyBadExecption", "Server Exception {0}", ((Exception)objres[i]).getMessage()) : new VWException("vw.api.WElockManyBadReturnType", "Server Exception {0}", objres[i]));
        }
        return results;
    }

    protected void setException(String anInstructionSheetName, String aDescription) throws VWException {
        String authISName;
        this.exceptionInstructionSheet = authISName = this.authorStr(anInstructionSheetName);
        this.exceptionDescription = aDescription;
        this.isExceptionMap = true;
    }

    protected String getExceptionInstructionSheet() {
        return this.translateStr(this.exceptionInstructionSheet);
    }

    protected String getExceptionDescription() {
        return this.exceptionDescription;
    }

    protected static VWException[] unlockSave(VWWorkElement[] elements, int saveType, boolean bindAll, String userToBind, String exISheetName, String exDescription, boolean isExMap, boolean unlockAll, boolean dispatchAll) throws VWException {
        VWField[] fields;
        int viewId = 0;
        if (elements == null || elements.length < 1) {
            throw new VWException("vw.api.WEUnlockSaveNoElements", "WorkObject or Element is null. No object to save, unlock and/or dispatch. ");
        }
        if (elements[0] == null) {
            throw new VWException("vw.api.WEUnlockSaveNoArrayElement", "WorkObject or Element is null. No object to save, unlock and/or dispatch at index {0}. ", 0);
        }
        IPECommands cmdSession = elements[0].getSession();
        String sourceName = elements[0].sourceQuery.querySource.name;
        viewId = elements[0].sourceQuery.querySource.viewId;
        VWField[][] values = null;
        if (saveType != 0 && (fields = elements[0].getUpdateFields()) != null) {
            values = new VWField[elements.length][];
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i] != null) {
                    if (!sourceName.equals(elements[i].sourceQuery.querySource.name)) {
                        throw new VWException("vw.api.WEUnlockSaveElementsNotOfOneQuery", "WorkObject or Element {0}, not from same query source {1}. ", i, sourceName);
                    }
                } else {
                    throw new VWException("vw.api.WEUnlockSaveNoArrayElement", "WorkObject or Element is null. No object to save, unlock and/or dispatch at array {0}. ", i);
                }
                values[i] = elements[i].getUpdateFields();
            }
        }
        VWException[] results = null;
        Object[] objres = null;
        objres = cmdSession.unlockSave(viewId, elements[0].sourceQuery.queryType, VWWorkElement.getWorkObjectIds(elements), saveType, values, bindAll, userToBind, exISheetName, exDescription, isExMap, unlockAll, dispatchAll, false, elements[0].sourceQuery.userBoundQueueQuery);
        int resLen = objres == null ? 0 : objres.length;
        results = new VWException[resLen];
        for (int i = 0; i < resLen; ++i) {
            if (objres[i] instanceof VWWorkObjectID) {
                elements[i].workObjectId = (VWWorkObjectID)objres[i];
                results[i] = null;
                elements[i].resetAlteredFieldsFlag();
                continue;
            }
            if (objres[i] == null) {
                results[i] = null;
                elements[i].resetAlteredFieldsFlag();
                continue;
            }
            results[i] = objres[i] instanceof VWException ? (VWException)objres[i] : (objres[i] instanceof Exception ? new VWException("vw.api.WEunlockManyBadExecption", "Server Exception {0}", ((Exception)objres[i]).getMessage()) : new VWException("vw.api.WEunlockManyBadReturnType", "Server Exception {0}", objres[i]));
        }
        return results;
    }

    protected static VWException[] unlockMany(VWWorkElement[] elements, boolean dispatch) throws VWException {
        return VWWorkElement.unlockSave(elements, 0, false, null, null, null, false, true, dispatch);
    }

    protected static VWException[] terminateMany(VWWorkElement[] elements) throws VWException {
        if (elements == null || elements.length < 1) {
            throw new VWException("vw.api.WETerminateManyNoElements", "WorkObject or Element is null. No object to terminate. ");
        }
        IPECommands cmdSession = null;
        int viewId = 0;
        if (elements[0] == null) {
            throw new VWException("vw.api.WETerminateManyNoArrayElement", "WorkObject or Element is null. No object to terminate at index {0}. ", 0);
        }
        cmdSession = elements[0].getSession();
        viewId = elements[0].sourceQuery.querySource.viewId;
        VWException[] results = null;
        boolean trynormal = true;
        Object[] objres = null;
        if (trynormal) {
            objres = cmdSession.terminateWorkObject(viewId, elements[0].sourceQuery.queryType, VWWorkElement.getWorkObjectIds(elements), false, elements[0].sourceQuery.userBoundQueueQuery);
        }
        int resLen = objres == null ? 0 : objres.length;
        results = new VWException[resLen];
        for (int i = 0; i < resLen; ++i) {
            results[i] = objres[i] == null ? null : (objres[i] instanceof VWException ? (VWException)objres[i] : (objres[i] instanceof Exception ? new VWException("vw.api.WEterminateManyBadExecption", "Server Exception {0}", ((Exception)objres[i]).getMessage()) : new VWException("vw.api.WEterminateManyBadReturnType", "Server Exception {0}", objres[i])));
        }
        return results;
    }

    protected static VWException[] deleteMany(VWWorkElement[] elements, boolean overrideLock, boolean force) throws VWException {
        if (elements == null || elements.length < 1) {
            throw new VWException("vw.api.WEDeleteManyNoElements", "WorkObject or Element is null. No object to delete. ");
        }
        IPECommands cmdSession = null;
        int viewId = 0;
        if (elements[0] == null) {
            throw new VWException("vw.api.WEDeleteManyNoArrayElement", "WorkObject or Element is null. No object to delete at index {0}. ", 0);
        }
        cmdSession = elements[0].getSession();
        viewId = elements[0].sourceQuery.querySource.viewId;
        VWException[] results = null;
        boolean trynormal = true;
        Object[] objres = null;
        if (trynormal) {
            objres = cmdSession.deleteWorkObject(viewId, elements[0].sourceQuery.queryType, VWWorkElement.getWorkObjectIds(elements), overrideLock, force, false, elements[0].sourceQuery.userBoundQueueQuery);
        }
        int resLen = objres == null ? 0 : objres.length;
        results = new VWException[resLen];
        for (int i = 0; i < resLen; ++i) {
            results[i] = objres[i] == null ? null : (objres[i] instanceof VWException ? (VWException)objres[i] : (objres[i] instanceof Exception ? new VWException("vw.api.WEDeleteManyBadExecption", "Server Exception {0}", ((Exception)objres[i]).getMessage()) : new VWException("vw.api.WEDeleteManyBadReturnType", "Server Exception {0}", objres[i])));
        }
        return results;
    }

    protected void lock(boolean overrideLock, int resultType) throws VWException {
        VWException[] rets = VWWorkElement.lockMany(new VWWorkElement[]{this}, overrideLock, resultType);
        if (rets != null && rets[0] != null) {
            throw rets[0];
        }
    }

    protected void unlock(boolean dispatch) throws VWException {
        VWException[] rets = VWWorkElement.unlockMany(new VWWorkElement[]{this}, dispatch);
        if (rets != null && rets[0] != null) {
            throw rets[0];
        }
    }

    protected void terminate() throws VWException {
        VWException[] rets = VWWorkElement.terminateMany(new VWWorkElement[]{this});
        if (rets != null && rets[0] != null) {
            throw rets[0];
        }
    }

    protected void delete(boolean overrideLock, boolean force) throws VWException {
        VWException[] rets = VWWorkElement.deleteMany(new VWWorkElement[]{this}, overrideLock, force);
        if (rets != null && rets[0] != null) {
            throw rets[0];
        }
    }

    protected int fetchLockedStatus() throws VWException {
        int intResult = -1;
        int viewId = this.sourceQuery.querySource.viewId;
        Object[] results = this.getSession().getLockStatus(viewId, this.sourceQuery.queryType, new VWWorkObjectID[]{this.workObjectId}, false, this.sourceQuery.userBoundQueueQuery);
        if (results.length != 1) {
            throw new VWException("vw.api.WEFetchLockedStatusWrongResultSize", "The field data fetched from the server was the wrong size.");
        }
        if (!(results[0] instanceof Long)) {
            if (results[0] instanceof VWException) {
                throw (VWException)results[0];
            }
            throw new VWException("vw.api.WEFetchLockedStatusWrongType", "The locked status data fetched from the server was the wrong type.");
        }
        intResult = ((Long)results[0]).intValue();
        return intResult;
    }

    protected VWDataField getDataField(String fieldName) throws VWException {
        String authFieldName = this.authorStr(fieldName);
        return super.getDataField(authFieldName);
    }

    protected VWField getField(String fieldName) {
        String authFieldName = this.authorStr(fieldName);
        return super.getField(authFieldName);
    }

    protected VWParameter getParameter(String name) throws VWException {
        String authName = this.authorStr(name);
        return super.getParameter(authName);
    }

    protected boolean hasFieldName(String fieldName) throws VWException {
        String authFieldName = this.authorStr(fieldName);
        return super.hasFieldName(authFieldName);
    }

    protected boolean getIsAltered() {
        return super.getIsAltered();
    }

    protected String getWorkObjectNumber() throws VWException {
        return super.getWorkObjectNumber();
    }

    protected void doReassign(VWWorkElement[] elements, int saveType, String theDomainName, String participantName, boolean delegateFlag, String queueName, String exISheetName, String exDescription, boolean isExMap, long argFlag) throws VWException {
        if (participantName == null || participantName.length() == 0) {
            throw new VWException("vw.api.VWWorkElementReAssignNullParticipant", "participant is null");
        }
        int viewId = 0;
        IPECommands cmdSession = elements[0].getSession();
        viewId = elements[0].sourceQuery.querySource.viewId;
        VWField[] values = null;
        if (saveType != 0) {
            values = elements[0].getUpdateFields();
        }
        cmdSession.doReassign(viewId, elements[0].sourceQuery.queryType, elements[0].workObjectId, saveType, theDomainName, participantName, delegateFlag, queueName, values, exISheetName, exDescription, isExMap, false, elements[0].sourceQuery.userBoundQueueQuery, argFlag);
    }

    protected void doReturn(VWWorkElement[] elements, int saveType, String exISheetName, String exDescription, boolean isExMap) throws VWException {
        boolean trynormal;
        IPECommands cmdSession = this.getSession();
        int viewId = elements[0].sourceQuery.querySource.viewId;
        VWField[] values = null;
        if (saveType != 0) {
            values = elements[0].getUpdateFields();
        }
        if (trynormal = true) {
            cmdSession.doReturn(viewId, elements[0].sourceQuery.queryType, elements[0].workObjectId, saveType, values, exISheetName, exDescription, isExMap, false, elements[0].sourceQuery.userBoundQueueQuery);
        }
    }

    protected VWStepProcessorInfo fetchStepProcessorInfo() throws VWException {
        VWStepProcessorInfo result = null;
        int processorId = this.getProcessorId();
        if (processorId != -1) {
            result = this.getSession().getStepProcessorById(processorId, this.sourceQuery.querySource.serviceSession.webAppId);
        }
        if (result != null) {
            result.setDefaultWebAppId(this.sourceQuery.querySource.serviceSession.getDefaultWebApplication());
            result.setIsolatedRegionWebAppId(this.sourceQuery.querySource.serviceSession.getIsolatedRegionWebApp());
            result.setSession(this.sourceQuery.querySource.serviceSession);
        }
        return result;
    }

    protected VWProcess fetchProcess(int workSpaceId, int workClassId, String workflowNumber) throws VWException {
        VWProcess process = this.getSession().getProcess(workSpaceId, workClassId, workflowNumber);
        return process;
    }

    protected void setCallMap(String aMapName) throws VWException {
        this.mapName = this.authorStr(aMapName);
        this.isExceptionMap = false;
    }

    protected String getCallMap() {
        return this.mapName;
    }

    protected boolean getIsExceptionMap() {
        return this.isExceptionMap;
    }

    protected String getOriginator() throws VWException {
        String result = super.getOriginator();
        return result;
    }

    protected VWParticipant getOriginatorPx() throws VWException {
        VWParticipant result = super.getOriginatorPx();
        if (result != null) {
            result.setCommandSession(this.theCmdSession);
        }
        return result;
    }

    protected String getLockedUser() throws VWException {
        String result = super.getLockedUser();
        return result;
    }

    protected VWParticipant getLockedUserPx() throws VWException {
        VWParticipant result = super.getLockedUserPx();
        if (result != null) {
            result.setCommandSession(this.theCmdSession);
        }
        return result;
    }

    protected VWParticipant getBoundUserPx() throws VWException {
        VWParticipant result = super.getBoundUserPx();
        if (result != null) {
            result.setCommandSession(this.theCmdSession);
        }
        return result;
    }

    protected String getParticipantName() throws VWException {
        String result = super.getParticipantName();
        return result;
    }

    protected String[] getStepResponses() throws VWException {
        this.availableResponses = (Object[])this.getFieldValue("*F_StepResponses", true);
        if (this.availableResponses == null) {
            return null;
        }
        return this.translateArr((String[])this.availableResponses);
    }

    protected String getSelectedResponse() throws VWException {
        if (this.selectedResponse == -1) {
            Object[] responses = null;
            int response = 0;
            responses = (Object[])this.getFieldValue("F_Responses", true);
            if (responses == null) {
                return null;
            }
            for (int i = 0; i < responses.length; ++i) {
                if (responses[i] == null || (response = ((Integer)responses[i]).intValue()) != 1) continue;
                this.selectedResponse = i;
                break;
            }
        }
        if (this.availableResponses == null) {
            this.getStepResponses();
        }
        if (this.selectedResponse != -1 && this.availableResponses != null) {
            return this.translateStr((String)this.availableResponses[this.selectedResponse]);
        }
        return null;
    }

    protected void setSelectedResponse(String response) throws VWException {
        Integer[] responses;
        if (this.availableResponses == null) {
            this.getStepResponses();
        }
        if (this.availableResponses != null && response != null) {
            String authResponse = this.authorStr(response);
            responses = new Integer[this.availableResponses.length];
            for (int i = 0; i < this.availableResponses.length; ++i) {
                if (authResponse.equals(this.availableResponses[i])) {
                    this.selectedResponse = i;
                    responses[i] = 1;
                    continue;
                }
                responses[i] = 0;
            }
        } else {
            throw new VWException("vw.api.WOSetSelectedResponseResponsesAreNull", "There are no available responses to set.");
        }
        this.setFieldValue("F_Responses", responses, false);
    }

    protected String getStepDescription() throws VWException {
        String value = null;
        Object tmpval = null;
        tmpval = this.hasFieldName("*F_StepDescription") ? this.getFieldValue("*F_StepDescription") : this.getFieldValue("F_StepDescription", true);
        if (tmpval != null && tmpval instanceof String) {
            value = (String)tmpval;
        }
        return this.translateStr(value);
    }

    protected VWParticipant getParticipantNamePx() throws VWException {
        VWParticipant result = super.getParticipantNamePx();
        if (result != null) {
            result.setCommandSession(this.theCmdSession);
        }
        return result;
    }

    protected VWReturnStackElement[] fetchReturnStackElements() throws VWException {
        VWReturnStackElement[] results = null;
        boolean trynormal = true;
        if (trynormal) {
            results = this.getSession().getReturnStackElements(this.sourceQuery.querySource.viewId, this.sourceQuery.queryType, this.workObjectId, this.sourceQuery.userBoundQueueQuery);
        }
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                results[i].setSession(this.sourceQuery.querySource.serviceSession);
            }
        }
        return results;
    }

    protected Object getFieldValue(String fieldName, boolean dontThrow) throws VWException {
        String authFieldName = this.authorStr(fieldName);
        Object result = super.getFieldValue(authFieldName, dontThrow);
        if (result != null) {
            if (result instanceof VWParticipant) {
                ((VWParticipant)result).setCommandSession(this.theCmdSession);
            } else if (result instanceof VWParticipant[]) {
                VWParticipant[] vwParticipants = (VWParticipant[])result;
                for (int i = 0; i < vwParticipants.length; ++i) {
                    if (vwParticipants[i] == null) continue;
                    vwParticipants[i].setCommandSession(this.theCmdSession);
                }
            }
        }
        return result;
    }

    protected Object getFieldValue(String fieldName) throws VWException {
        return this.getFieldValue(fieldName, false);
    }

    protected VWParticipant[] getTrackersPx() throws VWException {
        VWParticipant[] result = super.getTrackersPx();
        if (result != null) {
            VWParticipant[] vwParticipants = result;
            for (int i = 0; i < vwParticipants.length; ++i) {
                if (vwParticipants[i] == null) continue;
                vwParticipants[i].setCommandSession(this.theCmdSession);
            }
        }
        return result;
    }

    protected IPECommands getSession() throws VWException {
        if (this.theCmdSession == null && this.sourceQuery != null && this.sourceQuery.querySource != null) {
            this.theCmdSession = this.sourceQuery.querySource.cmdSession;
        }
        return this.theCmdSession;
    }

    protected String translateStr(String inStr) {
        IPECommands session = null;
        try {
            session = this.getSession();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (session != null) {
            try {
                return session.translate(inStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return inStr;
    }

    protected String[] translateArr(String[] inStrs) {
        IPECommands session = null;
        try {
            session = this.getSession();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] outStrs = null;
        if (inStrs != null) {
            int arrCount = inStrs.length;
            outStrs = new String[arrCount];
            if (session != null) {
                for (int i = 0; i < arrCount; ++i) {
                    try {
                        outStrs[i] = session.translate(inStrs[i]);
                        continue;
                    }
                    catch (Exception e) {
                        outStrs[i] = inStrs[i];
                    }
                }
                return outStrs;
            }
        }
        return inStrs;
    }

    protected String authorStr(String inStr) {
        if (inStr == null) {
            return null;
        }
        IPECommands session = null;
        try {
            session = this.getSession();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (session != null) {
            try {
                return session.translateToAuthored(inStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return inStr;
    }

    protected String getWorkObjectName() throws VWException {
        String value = super.getWorkObjectName();
        return this.translateStr(value);
    }

    protected String getWorkClassName() throws VWException {
        String value = super.getWorkClassName();
        return this.translateStr(value);
    }

    protected String getAuthoredWorkClassName() throws VWException {
        return super.getWorkClassName();
    }

    protected String getWorkPerformerClassName() throws VWException {
        String value = super.getWorkPerformerClassName();
        return this.translateStr(value);
    }

    protected String getCurrentQueueName() throws VWException {
        String value = super.getCurrentQueueName();
        return this.translateStr(value);
    }

    protected String getOperationName() throws VWException {
        String value = super.getOperationName();
        return this.translateStr(value);
    }

    protected String getAuthoredInstructionSheetName() throws VWException {
        return super.getInstructionSheetName();
    }

    protected String getInstructionSheetName() throws VWException {
        String value = super.getInstructionSheetName();
        return this.translateStr(value);
    }

    protected String getLastErrorText() throws VWException {
        return super.getLastErrorText();
    }

    protected String getResponse() throws VWException {
        String value = super.getResponse();
        return this.translateStr(value);
    }

    protected String getSubject() throws VWException {
        String value = super.getSubject();
        return this.translateStr(value);
    }

    protected String getWorkflowName() throws VWException {
        String value = super.getWorkflowName();
        return this.translateStr(value);
    }

    protected String getRosterName() throws VWException {
        String value = super.getRosterName();
        return this.translateStr(value);
    }

    protected String getStepName() throws VWException {
        String value = super.getStepName();
        return this.translateStr(value);
    }

    protected String getAuthoredStepName() throws VWException {
        return super.getStepName();
    }

    protected boolean hasBeenAltered(String fieldName) throws VWException {
        String authFieldName = this.authorStr(fieldName);
        return super.hasBeenAltered(authFieldName);
    }

    protected String[] getFieldNames(boolean getSystemFields) {
        String[] values = super.getFieldNames(getSystemFields);
        return this.translateArr(values);
    }

    protected String[] getFieldNames() {
        String[] values = super.getFieldNames();
        return this.translateArr(values);
    }

    protected String[] getAuthoredFieldNames() {
        return super.getFieldNames();
    }

    protected String[] getFilteredFieldNames(boolean getSystemDefinedFields) {
        String[] values = super.getFilteredFieldNames(getSystemDefinedFields);
        return this.translateArr(values);
    }

    protected void setFieldValue(String fieldName, Object fieldValue, boolean compareValue) throws VWException {
        String authFieldName = this.authorStr(fieldName);
        super.setFieldValue(authFieldName, fieldValue, compareValue);
    }

    protected boolean isSystemField(String fieldName) throws VWException {
        String authFieldName = this.authorStr(fieldName);
        return super.isSystemField(authFieldName);
    }

    protected int getFieldMode(String fieldName) throws VWException {
        String authFieldName = this.authorStr(fieldName);
        return super.getFieldMode(authFieldName);
    }

    protected void setSession(IPECommands ses) {
        this.theCmdSession = ses;
    }

    protected double getUniqueId() throws VWException {
        return this.workObjectId == null ? 0.0 : this.workObjectId.getUniqueID();
    }

    protected Object getTranslatedFieldValue(String fieldName) throws VWException {
        if (fieldName.startsWith("F_")) {
            if (fieldName.equals("F_InstrSheetName")) {
                return this.getInstructionSheetName();
            }
            if (fieldName.equals("F_Operation")) {
                return this.getOperationName();
            }
            if (fieldName.equals("F_Response")) {
                return this.getSelectedResponse();
            }
            if (fieldName.equals("F_StepDescription")) {
                return this.getStepDescription();
            }
            if (fieldName.equals("F_StepName")) {
                return this.getStepName();
            }
            if (fieldName.equals("F_Subject")) {
                return this.getSubject();
            }
            if (fieldName.equals("F_Class")) {
                return this.getWorkClassName();
            }
        }
        return this.getFieldValue(fieldName);
    }
}

